<div class="edgtf-testimonial-content" id="edgtf-testimonials-<?php echo esc_attr( $current_id ) ?>">
    <span class="edgtf-icon-quote icon_quotations"></span>
	<div class="edgtf-testimonial-text-holder">
        <?php if ( ! empty( $title ) ) { ?>
            <h4 itemprop="name" class="edgtf-testimonial-title entry-title <?php echo esc_attr($title_classes) ?>"><?php echo wp_kses($title, array('br' => true, 'span' => array('class' => true))); ?></h4>
        <?php } ?>
		<?php if ( ! empty( $text ) ) { ?>
			<p class="edgtf-testimonial-text"><?php echo esc_html( $text ); ?></p>
		<?php } ?>
		<?php if ( has_post_thumbnail() || ! empty( $author ) ) { ?>
			<div class="edgtf-testimonials-author-holder clearfix">
				<?php if ( has_post_thumbnail() ) { ?>
					<div class="edgtf-testimonial-image">
						<?php echo get_the_post_thumbnail( get_the_ID(), array( 85, 85 ) ); ?>
					</div>
				<?php } ?>
				<?php if ( ! empty( $author ) ) { ?>
					<h6 class="edgtf-testimonial-author">
						<span class="edgtf-testimonials-author-name"><?php echo esc_html( $author ); ?></span>
						<?php if ( ! empty( $position ) ) { ?>
							<span class="edgtf-testimonials-author-job"><?php echo esc_html( $position ); ?></span>
						<?php } ?>
					</h6>
				<?php } ?>
			</div>
		<?php } ?>
	</div>
</div>